/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class MetricsCounter {
    private final Map<Service, AtomicInteger> map = new EnumMap<Service, AtomicInteger>(Service.class);

    public void increment(Service service) {
        this.map.putIfAbsent(service, new AtomicInteger());
        this.map.get((Object)service).incrementAndGet();
    }

    public int collect(Service service) {
        this.map.putIfAbsent(service, new AtomicInteger());
        return this.map.get((Object)service).getAndSet(0);
    }

    public int collectMineskinCalls() {
        return this.collect(Service.MINE_SKIN);
    }

    public int collectMinetoolsCalls() {
        return this.collect(Service.MINE_TOOLS);
    }

    public int collectMojangCalls() {
        return this.collect(Service.MOJANG);
    }

    public int collectAshconCalls() {
        return this.collect(Service.ASHCON);
    }

    public static enum Service {
        MINE_SKIN,
        MINE_TOOLS,
        MOJANG,
        ASHCON;

    }
}

